﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;


/* Thread.Abort() */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
        }



        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        SynchronizationContext synContext;
        Thread t = null;
        bool executing = false;

        void ThreadProc()
        {
            try
            {
                executing = true;
                synContext.Send(SynchronizedMethod, "thread started");

                while (true)
                {
                    Thread.Sleep(100);
                }
            }
            catch (ThreadAbortException)
            {
                executing = false;
                synContext.Send(SynchronizedMethod, "thread aborted");
            }
        } 

        private void btnStart_Click(object sender, EventArgs e)
        {
            if (!executing)
            {
                t = new Thread(ThreadProc);
                t.Start();
            }
        }

        private void btnAbort_Click(object sender, EventArgs e)
        {
            if (executing)
            {
                t.Abort();
                t.Join(1000);
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = executing;

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }
 
    }
}
 